//sendmail
#include <unistd.h> 
#include <sys/wait.h>
#ifndef SENDMAIL_PATH
	#define SENDMAIL_PATH "/usr/lib/sendmail"
#endif
#ifndef ASCII
	#define ASCII    0x00
	#define JAPANESE 0xff
#endif

struct sendmail
{
public:
	const char *to;
	const char *subject;
	const char *cc;
	const char *myname;
	const char *myaddr;
	const char *re_path;
	const char *message;
	const char *err_to;
	sendmail()
	{
		static char nullstr[]="";
		to = subject = cc = myname = myaddr = re_path = message = err_to = nullstr;
	}
	
private:
	void EUCtoJIS(const char* text , char* newbuff)
	{
		static const u_char kana_table[] = {
    		0x21,0x23,0x21,0x56,0x21,0x57,0x21,0x22,
 		   	0x21,0x26,0x25,0x72,0x25,0x21,0x25,0x23,
  			0x25,0x25,0x25,0x27,0x25,0x29,0x25,0x63,
    		0x25,0x65,0x25,0x67,0x25,0x43,0x21,0x3C,
    		0x25,0x22,0x25,0x24,0x25,0x26,0x25,0x28,
    		0x25,0x2A,0x25,0x2B,0x25,0x2D,0x25,0x2F,
    		0x25,0x31,0x25,0x33,0x25,0x35,0x25,0x37,
    		0x25,0x39,0x25,0x3B,0x25,0x3D,0x25,0x3F,
    		0x25,0x41,0x25,0x44,0x25,0x46,0x25,0x48,
    		0x25,0x4A,0x25,0x4B,0x25,0x4C,0x25,0x4D,
    		0x25,0x4E,0x25,0x4F,0x25,0x52,0x25,0x55,
    		0x25,0x58,0x25,0x5B,0x25,0x5E,0x25,0x5F,
    		0x25,0x60,0x25,0x61,0x25,0x62,0x25,0x64,
    		0x25,0x66,0x25,0x68,0x25,0x69,0x25,0x6A,
    		0x25,0x6B,0x25,0x6C,0x25,0x6D,0x25,0x6F,
    		0x25,0x73,0x21,0x2B,0x21,0x2C
    	};
 
		//((b1 >= 0xA1 && b1 <= 0xF4) && (b2 >= 0xA0 && b2 <= 0xFE)) //EUC	
		int mode=ASCII;
	  	u_char *wr, *re;
	  	wr=(u_char*)newbuff, re=(u_char*)text;
	  	
	  	while(*re) {
 	  		if( *re < 0x80 ) {
 	    		if( mode != ASCII ) {
					mode  = ASCII;		
					*wr++ = 0x1B; *wr++ = '('; *wr++ = 'B'; // [ESC]KOUT
 	     		}
 	     		*wr++ = *re++;
	    	}
	    	else
	    	{
				if( mode != JAPANESE ) {
					mode  = JAPANESE;
					*wr++ = 0x1B; *wr++ = '$'; *wr++ = 'B';	 // [ESC]KIN
 	    		}
				if(*re==0x8E) {	//EUCȾѥ->JIS
					re++;
					if( *re>=0x21 && *re<= 0x5F) {
						//̤EUCȾѥʤξ
						const int index = 2*(*re++ - 0x21);
						*wr++ = kana_table[index+0];
  						*wr++ = kana_table[index+1];
  					}
  					else 
  					{
						if( *re>=0xA1 && *re<= 0xDF) {
							//ʳ¸ߤSJISɤEUCȾѥʤξ
							const int index = 2*(*re++ - 0xA1);
							*wr++ = kana_table[index+0];
  							*wr++ = kana_table[index+1];
  						}
  						else { *wr++ = '?' ; re++; } 
  					}
  				}
  				else
  				{
					if( *(re+1) == 0 ) break;
					*wr++ = *re++ & (unsigned char)0x7f;  // ->JIS 
 	     			*wr++ = *re++ & (unsigned char)0x7f;   
 	     		}
	    	}
 	 	}
 	 	if( mode != ASCII ){
 	 		mode  = ASCII;
	   		*wr++ = '\x1b';  *wr++ = '(';  *wr++ = 'B';
	 	}
	 	*wr = '\0';
  	}

public:
    FILE *pd;
	//int pid;
	//int pipefds[2];
	void mopen(void)
	{
		/* ʲѥפȤäƻҥץǺư
		pipe( pipefds );           // Prepare pipe descriptors.
		//sigignore( SIGCLD );//unix only? // ҥץϾ˻˴褦ˤ

		if ( (pid=fork()) == 0 )
		{  	
		    //ҥץ¦ 
 		   	dup2( pipefds[0], 0 );
 		   	close(pipefds[0]);
    		close(pipefds[1]);  
       		
	   		execl(SENDMAIL_PATH, "sendmail", to, 0 );
	   		// execl  
     	   	printf("Error: Can not exec sendmail.\n");
     		exit(1); // ҥץ۾ｪλ  
		}
   		// ƥץν
		close(pipefds[0]);
		pd = fdopen( pipefds[1], "w" );
		*/
		
		char *newbuff;
		newbuff = new char [ ( strlen(subject)+strlen(myname) )*3 + 256 ];
				
		sprintf( newbuff, SENDMAIL_PATH " %s", to);
		pd = popen( newbuff, "w" ); if(pd==NULL) Die("sendmail");
		
		//mail-header
		
		EUCtoJIS( subject, newbuff);
		fprintf( pd, "Subject: %s\n" , newbuff );	
		
		EUCtoJIS( myname, newbuff);
		fprintf( pd, "Errors-To: %s\n", err_to );
		fprintf( pd, "From: \"%s\" <%s>\n", newbuff, myaddr);
		fprintf( pd, "To: %s\n", to);
		fprintf( pd, "Cc: %s\n", cc);       
		
		fprintf( pd, "Return-Path: %s\n",re_path);
		fprintf( pd, "MIME-Version: 1.0\n" );			
		fprintf( pd, "Content-Type: text/plain; charset=iso-2022-jp\n");
		fprintf( pd, "Content-Transfer-Encoding: 7bit\n\n");
		delete newbuff;
	}
	
	void mwrite(const char* text)
	{
		char *newbuff;
		newbuff = new char [ ( strlen(text) )*3 + 256 ];
		
		EUCtoJIS(text, newbuff);
		fputs( newbuff, pd);
		//fprintf( pd, ".\n" );
		delete newbuff;
	}
	
	void mclose(void)
	{
		fclose( pd );
		//waitpid(pid, NULL, 0);     // Wait until the child exits.
	}
	
	void send(void)
	{
		mopen();
		mwrite(message);
		mclose();
	}
};

static const char purl_0[] = {
		 0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x20,0x3d,0x20,
		 0x22,0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x3c,0x61,0x20,
		 0x68,0x72,0x65,0x66,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,
		 0x2f,0x2f,0x77,0x77,0x77,0x2e,0x70,0x6c,0x61,0x6e,0x65,
		 0x74,0x2d,0x67,0x72,0x65,0x65,0x6e,0x2e,0x63,0x6f,0x6d,
		 0x2f,0x22,0x20,0x74,0x61,0x72,0x67,0x65,0x74,0x3d,0x22,
		 0x5f,0x62,0x6c,0x61,0x6e,0x6b,0x22,0x3e,0xa4,0xd7,0xa4,
		 0xe9,0xa4,0xcd,0xa4,0xc3,0xa4,0xc8,0xa4,0xb0,0xa4,0xea,
		 0xa1,0xc1,0xa4,0xf3,0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x70,
		 0x3e,0x00
};
