//================================================================
//    ꥪ 
//    2001.10.18 -   
//    Copyright(C) 2001. Planet-Green All rights reserved.
//	  http://www.planet-green.com/
//================================================================

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>


//Die
//---- 顼åɽƽλؿ
void Die(const char* msg )
{
  if(errno){
  	printf( "Error : %s : %s", msg, sys_errlist[errno] );
  } else {
    printf( "Error : %s", msg );
  }
  exit(1);
}



#include "setting.h"	//Ƽdefine
//#include "ItemClass.cpp"
#include "gamedata.cpp"
#include "strcmp2.c"
#include "OutputFromFileClass.cpp"


static	char common_buff[80];

//󥿡Υ饹
//ǥ󥿵ǽƯ
class CounterClass
{
private:
	FILE *fd;
	char       tmp_buff[256];
	
	time_t now;
	tm     *UTC;
	bool  ChangeDayFlag;
	
	#define TOTAL     	"Total     : %d\n"
	#define TODAY     	"Today     : %d\n"
	#define YESTERDAY 	"Yesterday : %d\n"
	#define TIMEFORMAT1 "LastAccess: %Y/%m/%d %H:%M:%S\n"
	#define TIMEFORMAT2 "LastAccess: %d/%d/%d %d:%d:%d\n"
	#define CF_NAME   	"counter.txt"
	
public:
	int total_c;
	int today_c;
	int yesterday_c;
	char LastDate[32];
	
	int counter_write(void)
	{
		fseek(fd,0,SEEK_SET);
		strftime(common_buff,80,P_TIME,localtime(&gdata.start_time));
		
		fprintf(fd, TOTAL,		total_c);
		fprintf(fd, TODAY,		today_c);
		fprintf(fd, YESTERDAY,	yesterday_c);
		
		strftime( tmp_buff,64,TIMEFORMAT1, localtime(&now) );
		fprintf(fd, "%s",	tmp_buff);
		return 0;
	}
	
	int counter_create(void)
	{
		total_c     = 0;
		yesterday_c = 0;
		today_c     = 0;
				
		fd = fopen( CF_NAME, "w");
		if(fd==NULL) {
			Die("File create error(counter.txt)");
			return 1;
		}
		
		if( lockf(fileno(fd), F_LOCK , 0) == -1 ) return 1;	//lock 
		
		counter_write();
		fclose(fd);
		
		return 0;
	}
		
	int counter_open(void)
	{
		if( access(CF_NAME, F_OK) ) {
			//ե뤬¸ߤʤ
			if( counter_create() ) Die("File open error(counter.txt)");
		}	
			
		fd = fopen( CF_NAME, "r+");
		if(fd == NULL) return 1;
		
		if( lockf(fileno(fd), F_LOCK , 0) == -1 ) return 1;	//lock 
		return 0;
	}
		
	int counter_read(void)
	{
		int yy, mm, dd, hh, mn, ss;
		
		//read
		fseek(fd,0,SEEK_SET);
		
		if(fgets(tmp_buff,64,fd) == NULL ) 				return 1;
		if(sscanf(tmp_buff,TOTAL,&total_c)==0 ) 		return 1;
			
		if(fgets(tmp_buff,64,fd) == NULL ) 				return 2;
		if(sscanf(tmp_buff,TODAY,&today_c)==0 ) 		return 2;
		
		if(fgets(tmp_buff,64,fd) == NULL ) 					return 3;
		if(sscanf(tmp_buff,YESTERDAY,&yesterday_c)==0 ) 	return 3;
		
		if(fgets(tmp_buff,64,fd) == NULL ) 								return 4;
		if(sscanf(tmp_buff,TIMEFORMAT2,&yy,&mm,&dd,&hh,&mn,&ss)==0 ) 	return 4;
		
		//󥿡
		if( yy != UTC->tm_year+1900 || mm != UTC->tm_mon+1 || dd != UTC->tm_mday )
		{
			yesterday_c = today_c;
		    today_c = 0;
		}
		
		today_c++;
		total_c++; 
		
		return 0;
	}
	
	CounterClass()	//󥹥ȥ饯
	{
		now = time(NULL);
		UTC = localtime(&now);
		
		if( counter_open() ) return ;
				
		if( counter_read()==0 ) counter_write();
		fclose(fd);
	}		
};
	




//ǡ
void gameload(FILE* fd) 
{
	fseek(fd,0,SEEK_SET);
	fread(&gdata,  sizeof(struct gamedata),		1           ,fd);
	//fread(p     ,  sizeof(struct playerdata),	MAX_PLAYER+1,fd);
	//fread(unit  ,  sizeof(struct unitdata),		MAX_UNIT+1,  fd);
	//fread(map   ,  sizeof(struct countrydata),	(MX*MY),	 fd);
	//fread(&Auction,sizeof(struct AuctionClass),	1,	 		 fd);
}

//gamedata_open
//ǡopen
FILE *gamedata_open(const char* mode , int room)
{
	FILE *fd;
	
	if(room<1 || room > MAX_ROOM) {
		Die("data_open");
	}
	
	sprintf(common_buff, "room%04u/data.cgi",room);	//ե͡
	fd = fopen(common_buff, mode);
	
	//if(fd==NULL) Die("data_open");
	
	//if( lockf(fileno(fd), F_LOCK , 0) == -1 ) Die("busy");  
	
	return fd;
}






#define L_COL "\"#FF8000\""
#define COL_2 "\"#FFE8C8\""
#define COL_1 "\"#F8F8E8\""


void p_sub(int room)
{

puts("
<table cellspacing=\"0\" cellpadding=\"8\" border=\"2\" align=\"center\" bordercolor=" L_COL " class=\"box\">
<tr>
<td>
<table cellspacing=\"2\" cellpadding=\"4\" class=\"s1\" border=\"0\" align=\"center\">

<tr>
<td nowrap rowspan=\"3\">
");

//
printf("
<p><b>ֹ %04u</b></p>
<p align=\"center\">
<input type=\"submit\" name=\"submit\" value=\"ENTER\" class=\"b1\" onClick=\"w_open(%d)\">
</p>
</td>
",room,room);

//
puts("
<td width=\"8\" nowrap>&nbsp;</td>
<td bgcolor=" COL_2 " nowrap></td>
<td nowrap bgcolor=" COL_2 " width=\"120\">
");

//
//bool Sanka_OK_Flag;
//if( gdata.flag.NoVacancy==0 ) Sanka_OK_Flag = 1;
//else                          Sanka_OK_Flag = 0;
	
switch(gdata.status)
{
	case G_STATUS_RECEPT_ENTRY:	//ȥ꡼
		if(gdata.flag.NoVacancy)	puts("<font color=\"#FF0000\"><b></b></font>");
		else						puts("ȥ꡼");
		break;
		
	case G_STATUS_NORMAL:		//೫
	
		if(gdata.flag.NoVacancy || SANKA_TURN_LIMIT < gdata.turn_count)
		{
			puts("<font color=\"#FF0000\"><b></b></font>");
		}
		else puts("òǽ");
		break;
		
	default:
	case G_STATUS_NOT_START:	//ཪλ塢ƥȤϤʤ
	case G_STATUS_GAMEOVER:		//ཪλ塢ȥ꡼
		
		puts("ཪλ");
}

//
puts("
</td>
<td nowrap width=\"8\">&nbsp;</td>
<td bgcolor=" COL_2 " nowrap>೫ϻ</td>
<td bgcolor=" COL_2 " nowrap>
");

//
strftime(common_buff,80,P_TIME,localtime(&gdata.start_time));
printf(common_buff);

//

puts("
</td>
</tr>
<tr>
<td nowrap width=\"8\">&nbsp;</td>
<td nowrap bgcolor=" COL_1 ">ߥ</td>
<td nowrap bgcolor=" COL_1 ">
");

//
switch(gdata.status)
{
	case G_STATUS_RECEPT_ENTRY:	//ȥ꡼
			printf("");
			break;

	default:
			printf("%d", gdata.turn_count+1);
			break;
}

//
puts(	"</td>"
		"<td nowrap width=\"8\">&nbsp;</td>"
		"<td bgcolor=" COL_1 " nowrap>ཪλ</td>"
		"<td bgcolor=" COL_1 " nowrap>"
		);

//
	time_t tmp;
	switch(gdata.status)
	{
		case G_STATUS_NOT_START:
		case G_STATUS_GAMEOVER:
				
				strftime(common_buff,80,P_TIME,localtime(&gdata.last_time));
				break;
				
		default:
				tmp = gdata.start_time + gdata.end_time;
				strftime(common_buff,80,P_TIME,localtime(&tmp));
				break;
	}
	
	printf(common_buff);

//
puts("
</td>
</tr>
<tr>
<td width=\"8\" nowrap>&nbsp;</td>
<td bgcolor=" COL_2 " nowrap>ü</td>
<td nowrap bgcolor=" COL_2 ">
");

//
printf("%d̾", gdata.ninzuu);

//
puts("
</td>
<td nowrap width=\"8\">&nbsp;</td>
<td bgcolor=" COL_2 " nowrap>1λ</td>
<td bgcolor=" COL_2 " nowrap>
");

//
printf("%d%dʬ",int(gdata.turn_time/3600), int(gdata.turn_time/60) % 60 );

//
puts("
</td>
</tr>
</table>
</td>
</tr>
</table>
");

}













void print_gameinfo(void)
{
	FILE	*fd;
	bool 	ExRoom = 0;
	int 	room ;
	
	for( room = 1 ; room <= MAX_ROOM ; room++ )
	{
		//sprintf( common_buff,"room%04u", room );	//Dir͡
		//if( access(common_buff, F_OK) == 0 )		//ǥ쥯ȥ¸߳ǧ
		//{
		
		//ǡե¸߳ǧ
		sprintf(common_buff, "room%04u/data.cgi", room );
		if( access(common_buff,F_OK) == 0 )
		{
			//ǡե뤬¸ߤ
			fd = gamedata_open("r", room);
			
			if(fd != NULL)	//顼̵openǤ
			{
				ExRoom = 1;
				gameload(fd);
				fclose(fd);
				
				p_sub(room);
				puts("<br>");
			}
		}
		//}
	}
	
	if(ExRoom==0) {
		puts("ब¸ߤޤ");
	}
}
	



int main(void)
{
	puts("Content-type: text/html\n");
	
	CounterClass Counter;
	
	setenv("TZ" , TIMEZONE , 1);	//糧å
	
	//ɽ
	OutputFile.open("_gate.html");	//ɽѥ饹ƤӽФ
	
	while(1)
	{
		register const char *ks;
		ks = OutputFile.read();
		if(ks == NULL) break;		//ｪλ
										
		//Ｐ  
		if(strcmp2(ks,"game_info")==0)  { print_gameinfo(); continue; }
		
		//ޤ	
		printf("{%s}",ks); 	//ɤˤ⳺ʤ硢{...}ɽ
	}
}	
