//common.c


//gamesave
//ǡ
void gamesave(FILE* fd) 
{
	#ifndef NO_SAVE
	fseek(fd,0,SEEK_SET);
	fwrite(&gdata,  sizeof(struct gamedata),    1, 				fd);
	fwrite(p	 ,  sizeof(struct playerdata),	MAX_PLAYER+1, 	fd);
	fwrite(unit  ,  sizeof(struct unitdata),	MAX_UNIT+1  , 	fd);
	fwrite(map   ,  sizeof(struct countrydata),	(MX*MY)     , 	fd);
	fwrite(&Auction,sizeof(struct AuctionClass),1, 				fd);
	#endif
}

//ǡ
void gameload(FILE* fd) 
{
	fseek(fd,0,SEEK_SET);
	fread(&gdata,  sizeof(struct gamedata),		1           ,fd);
	fread(p     ,  sizeof(struct playerdata),	MAX_PLAYER+1,fd);
	fread(unit  ,  sizeof(struct unitdata),		MAX_UNIT+1,  fd);
	fread(map   ,  sizeof(struct countrydata),	(MX*MY),	 fd);
	fread(&Auction,sizeof(struct AuctionClass),	1,	 		 fd);
}

//gamedata_open
//ǡopen
FILE *gamedata_open(const char* mode , int room)
{
	FILE *fd;
	
	if(room<1 || room > MAX_ROOM) {
		Die("data_open");
	}
	
	sprintf(common_buff, "room%04u/data.cgi",room);	//ե͡
	fd = fopen(common_buff, mode);
	
	if(fd==NULL) Die("data_open");
	
	//flock( fileno(fd), LOCK_EX );	//
	if( lockf(fileno(fd), F_LOCK , 0) == -1 ) Die("busy");  
	
	return fd;
}


//Die
//---- 顼åɽƽλؿ
void Die(const char* msg )
{
  if(errno){
  	printf( "Error : %s : %s", msg, sys_errlist[errno] );
  } else {
    printf( "Error : %s", msg );
  }
  exit(1);
}

//åɽ
//p_mes
void p_mes(const char* fname, const char* message)
{
	int room = Form.getform_i("room");
	
 	//ɽ
	OutputFile.open(fname);	//ɽѥ饹ƤӽФ
	
	while(1)
	{
		const char *ks;
		ks = OutputFile.read();
		if(ks == NULL) break;		//ｪλ
										
		//Ｐ  
		if(strcmp2(ks,"reload")==0)  { printf(SELF_NAME "?room=%d",room); continue; }
		if(strcmp2(ks,"message")==0) { printf(message);   continue; }
		if(strcmp2(ks,"room")==0)    { printf("%d",room); continue; }
		
		if(strcmp2(ks,"start_time")==0) {
			strftime(common_buff,25,"%Y/%m/%d(%a) %H:%M",localtime(&gdata.next_start));
	 		puts(common_buff);
	 		continue;
		}
		//ޤ	
		printf("{%s}",ks); 	//ɤˤ⳺ʤ硢{...}ɽ
	}				
//exit(0);
}	



//HTML
//ret: 椬У
//#ifndef RMHTMLTAG
//#define RMHTMLTAG
int rmHtmlTag(char *buff)
{
	u_char	*pr, *pw;	
	bool	flag  = 0;		//椫ȽǤflag
	bool	flag2 = 0;
		
	pr = (u_char*)buff;
	pw = pr;
	
	while(*pr)
	{
		if(*pr == '<') { flag = flag2 = 1; pr++; continue; }
		if(*pr == '>') { flag = 0        ; pr++; continue; }
		
		if(*pr=='\"' || *pr=='\'' || *pr=='&' || *pr=='%' || *pr=='\\' || *pr=='#'
		  || *pr<0x20
		  || (*pr==0x8E && 0xA1<=*(pr+1) && *(pr+1)<=0xDF)	//Ⱦѥ
		//  || (*pr!=0x8F && *pr>0x7E && *pr<0xA0)			//JIS
		)
		{
			flag2 = 1;
		}
		else
		{
			if(flag==0)	{
				*pw = *pr;
				pw++;
			}
		}
		pr++;
	}
	*pw = '\0';
	return flag2;
	
	//å 1Х 	2Х 	3Х	ܸEUCξ 
	//G0 	 0x210x7E - 			-			ASCII 
	//G1 	 0xA00xFF 0xA00xFF 	- 			JIS X 0208-1990ʿJIS 
	//G2 	 0x8E 		0xA00xFF 	- 			JIS X 0201ʡ1ХȲ̾ 
	//G3 	 0x8F 		0xA00xFF 	0xA00xFF	JIS X 0212-1990 
}
//#endif




//PROXYΥ
int ViaProxy(void)
{

	char *lpHost;
	if (getenv("HTTP_VIA") != NULL) 			return 1;
	if (getenv("HTTP_FORWARDED") != NULL)		return 1;
	if (getenv("HTTP_X_FORWARDED_FOR") != NULL) return 1;
	return 0;
}


//åɤ߼
//GetCooKie

//̥
int GetCooKie_sub(const char* keyname, char *tmp)
{
	register char *p;
	register int i=0;
	
	p = getenv( "HTTP_COOKIE" ); if(p==NULL) return 0;
	p = strstr(p,keyname) 	   ; if(p==NULL) return 0;
	p = strchr(p,'=');		   ; if(p==NULL) return 0;
	p++;
	while(p[i] && p[i]!=';' && i<32) { tmp[i] = p[i]; i++; }
	tmp[i] = 0;
	return 1;
}

int GetCooKie_i(const char* keyname)
{
	if( GetCooKie_sub(keyname, common_buff) ==0) return 0;
	return atoi(common_buff);
}

double GetCooKie_d(const char* keyname)
{
	if( GetCooKie_sub(keyname, common_buff) ==0) return 0;
	return atof(common_buff);
}

char* GetCooKie_c(const char* keyname)
{
	char *tmp;
	tmp = new char[34];
	if( GetCooKie_sub(keyname, tmp) ==0) return NULL;
	return tmp;
}


/*	åպ
			time_t t;
			tm     *UTC;
			char buff[28];
	
			time(&t); t=t+(60*60*24*90);	//åδ¤90ˤ
			UTC=gmtime(&t);
			strftime(buff,25,"expires=%a, %d-%b-%Y %H:%M:%S GMT; ",UTC);
			printf("%s",buff);
*/

//get_ip
//IP롣proxyä³ƿ̾proxyä
//proxyip
int get_ip(u_char *ip1, u_char *ip2, u_char *ip3, u_char *ip4)
{
	char *ipaddr;
		
	if(ViaProxy())	//proxyͳʤ
	{
		ipaddr = getenv("HTTP_X_FORWARDED_FOR");
		if(ipaddr == NULL || strcmp2(ipaddr,"unknown")==0) {
			//ƿ̾proxy
			ipaddr=getenv("REMOTE_ADDR");
		}
	}
	else
	{
		//proxy̵
		ipaddr = getenv("REMOTE_ADDR");
	}
		
	if(ipaddr != NULL)
	{
		int t1,t2,t3,t4;
		
		sscanf(ipaddr,"%d.%d.%d.%d",&t1,&t2,&t3,&t4);
		*ip1 = t1;
		*ip2 = t2;
		*ip3 = t3;
		*ip4 = t4;
		
		return 1;
	}
	else
	{
		*ip1 = *ip2 = *ip3 = *ip4 = 0;
		return 0;
	}
}


//logincheck
//åɤǥ󤷤Ƥ뤫ɤȽ
int loginCheck(void)
{
	time_t now;
	now  = time(NULL);
	const char *ipaddr;
	u_char ip1,ip2,ip3,ip4;
	playerdata *tp;
	
	int u = GetCooKie_i("user");
	if(u==0) return 0;
	
	tp = &p[u]; 
		
	//ipaddr = getenv("REMOTE_ADDR");
	//if(ipaddr!=NULL) sscanf(ipaddr,"%d.%d.%d.%d",&ip1,&ip2,&ip3,&ip4);
	//else ip1=ip2=ip3=ip4 = 255;	
	
	get_ip(&ip1, &ip2, &ip3, &ip4);
	
	if( tp->cookie_passkey == GetCooKie_i("passkey") && 
		tp->cookie_time>=now &&
		tp->ip_addr[0]==ip1 && tp->ip_addr[1]==ip2 &&
		tp->ip_addr[2]==ip3 && tp->ip_addr[3]==ip4     )
	{
		return u;
	}
	
	return 0;	
}

//hex_to_xy
// "C3" "D2" ʤɤηx,yѴ
int hex_to_xy(const char *hex , int *cx, int *cy)
{
	if(NULL==hex) { *cx=GHOST_MX;*cy=GHOST_MY; return 0; }
	*cy = hex[0] - 'A' ;
	*cx = hex[1] - '1' ;
		
	if( EexistHex(*cx,*cy) ) return 1;
	else {*cx=GHOST_MX ; *cy=GHOST_MY; return 0;}
}

//ε
char *xy_to_hex(int cx, int cy)
{
	static char cname[3] = { 0,0,0 };
	cname[0] = 'A' + cy;
	cname[1] = '1' + cx;
	return cname;
}

//EexistHex
//hex¸ߤ뤫ɤ֤
int EexistHex(int x, int y)
{
	if(x<0 || MX <= x || y<0 || MY <= y) return 0 ;
	if( (y % 2) && (MX-1 <= x) ) return 0;		//yԤ x1ľʤ
	return 1;
}

//NeighboringCountry
//顢hexդκɸ֤
int NeighboringCountry(int cx, int cy, int direction, int *rx, int *ry)
{
	switch(direction)
	{
		case 0:	*rx=cx  ; *ry=cy-1 ; if(*ry % 2) *rx = *rx-1; break;
		case 1: *rx=cx+1; *ry=cy-1 ; if(*ry % 2) *rx = *rx-1; break;
		case 2: *rx=cx+1; *ry=cy   ; break;
		case 3: *rx=cx+1; *ry=cy+1 ; if(*ry % 2) *rx = *rx-1; break;
		case 4: *rx=cx  ; *ry=cy+1 ; if(*ry % 2) *rx = *rx-1; break;
		case 5: *rx=cx-1; *ry=cy   ; break;
	}
	if( EexistHex(*rx,*ry) ) return 1;
	else return 0;
}










//info_edit
//ΤιˡƥѹΤʤɤѹ³
//1顼ä0
//mode 0: 1:Τ(cx,cy)
int info_edit(int mode, int sx, int sy)
{
	int ex,ey;
	countrydata *tmap;
	unitdata    *tunit;
		
	int ItemPool_c;
	int new_count;
	int it[5];			//ƥ
	int ItemPool[ITEM_IN_COUNTEY+5];
	
	//Τ
	char *wbattle, *wwin, *wlose;
	wbattle = Form.getform_c("WordsBattle") ;
	wwin    = Form.getform_c("WordsWin") ;
	wlose   = Form.getform_c("WordsLose");
	
	if(wbattle != NULL && strlen(wbattle) ) {
		rmHtmlTag(wbattle);
		p[user].setWordsBattle(wbattle);
	}
	
	if(wwin != NULL && strlen(wwin) ) {
		rmHtmlTag(wwin);
		p[user].setWordsWin(wwin);
	}
	
	if(wlose != NULL && strlen(wlose)) {
		rmHtmlTag(wlose);
		p[user].setWordsLose(wlose);
	}
	
	//
	if(mode) {
		ex = sx+1; ey = sy+1;
	} else {
		sx=0; sy=0; ex=MX; ey=MY;
	}
	
	for(int cx=sx ; cx<ex ; cx++ ) for(int cy=sy ; cy<ey ; cy++)
	{
		if( map[cx][cy].boss != user ) continue;
		tmap = &map[cx][cy];
				
		//ƥ
		//˥åȤΥƥࡦͭΥƥٽᡢ
		//ɤ߼äեǡ˱ƺʬۤ
		//Ĥ᤹
		
		new_count  = 0;
		ItemPool_c = 0;
		
		for(int i=0; i< ITEM_IN_COUNTEY   ; i++) {
			if( tmap->item[i] ) ItemPool[ItemPool_c++] = tmap->item[i];
		}
		
		//ǽΥ롼פǥƥΥեɤ߼äƽפ
		for(int i=0 ; i<5 ; i++)
		{
			int u = tmap->UnitId[i]; ;	//˥å
			if(0==u) continue;
						
			sprintf(common_buff,"ui%d" ,u);		//եफΤ뤫ɤ߼
			it[i] = Form.getform_i(common_buff);
					 
			if(it[i]) new_count++;
			//˥åȤλäƤ륢ƥ
			if(unit[u].item) ItemPool[ItemPool_c++] = unit[u].item;
		}
		
		if( ItemPool_c - new_count > ITEM_IN_COUNTEY) {
			snprintf(common_buff,sizeof(common_buff),
					"(%s)ˤϤʾΥƥ֤ޤ<br>"
					 "ʰĤϤ륢ƥ%dĤޤǤǤ"
					 ,xy_to_hex(cx,cy),ITEM_IN_COUNTEY
			);	
			
			p_mes(P_MES_BACK,common_buff);
			return 0;
		}	
		
		//ܤΥ롼פǥƥưĤǤ˥ν
		for(int i=0 ; i<5 ; i++)
		{
			int u = tmap->UnitId[i]; ;	//˥å
			if(0==u) continue;
			tunit = &unit[u];
			
			if(it[i])
			{
				int j=0;
				while( j<ItemPool_c && it[i]!=ItemPool[j]) j++;
				
				/*
				ΥɤȥȤǽˤʤΤǺ
				if( j==ItemPool_c ) {
					p_mes(P_MES_BACK,"ƥʣ򤷤Ƥޤ");
					return 0;
				}
				*/
				
				if( j != ItemPool_c )
				{
					unit[u].item = it[i];
					ItemPool[j] = 0;
				}
			}
			else unit[u].item = 0;
			
			
			//饹
			
			int sk;	//
									
			sprintf(common_buff,"us%d" ,u);//եफɤ߼
			sk = Form.getform_i(common_buff);
			
			if( SkillData[sk].SkillType != S_TYPE_None  &&  tunit->skill(sk) ) 	{
				tunit->SkillSelect = sk;
			}
		}
				
		for(int i=0,j=0; i<ITEM_IN_COUNTEY ; i++)
		{
			if(j<ItemPool_c ) tmap->item[i] = ItemPool[j++];
			else              tmap->item[i] = 0;
		}
		tmap->item_tume();
	}
	//p_mes(P_MES_RELOAD,"괰λ");
	return 1;
}	









//ȲۤǶ̤
//򤵤줿˥åȤɤ߼ؿ
int ReadSelectUnit(int *MyTable, short *map_unit)
{
	int count = 0;
	for(int i=0; i<5 ; i++)
	{
		sprintf( common_buff, "unit%d",i);
		int u = Form.getform_i(common_buff);
		if(u)
		{
			if( u != map_unit[i]) return -1;	//ΤϤʤ
			else MyTable[count++] = u; 
		}
	}
	return count;
}

//HomeHexCheck
//home_cx,home_cyå
void HomeHexCheck(int user)
{
	playerdata *tp;
	tp = &p[user];
	
	if( map[tp->home_cx][tp->home_cy].boss == user ) return;
	
	for(int cx=0;cx<MX;cx++) for(int cy=0;cy<MY;cy++) 
	{
		if( map[cx][cy].boss == user )
		{
			 tp->home_cx = cx;
			 tp->home_cy = cy;
			 return;
		}
	}
}



void set_starttime_at_gameover(time_t now)
{
	//೫Ϥвᤷ+waiting_periodnextgameǳꡢ
	//(ο+1)nexgamestart_time­ơΤ֤
	//int tmp =  ( now + gdata.turn_time - gdata.start_time) / gdata.nextgame; λ
	
	int tmp1 , tmp2;
	
	while( now > gdata.last_turn_time) gdata.last_turn_time += gdata.turn_time;
	
	//tmp  = (gdata.last_turn_time - gdata.start_time + gdata.waiting_period*2)/gdata.nextgame;
	
	tmp1 = gdata.last_turn_time - gdata.start_time + gdata.waiting_period * 2;
	tmp2 = (tmp1/gdata.nextgame);
	
	if(tmp1 % gdata.nextgame) tmp2++;
	
	gdata.next_start = gdata.nextgame * tmp2 + gdata.start_time;
}



void GameEndSetting(time_t now)
{
	if( gdata.nextgame )
	{
		gdata.status = G_STATUS_GAMEOVER;
		set_starttime_at_gameover(now);
	}
	else gdata.status = G_STATUS_NOT_START;	//ƥȤʤ
	gdata.last_time = now;
}	


//ཪλΥå
// 0:ϽλƤʤ  1:ཪλ
int CheckGameOver(int user)
{
	time_t now;
	now = time(NULL);
	
	int c;
		
	if( p[user].ryoudo >= GAME_CLEAR_COUNTRY 
	   || ( gdata.flag.enemy_mode && p[ENEMY_BOSS].status == STATUS_DEAD)
	)
	{
		GameEndSetting(now);
		return 1;
	}
	
	if(gdata.turn_count <= SANKA_TURN_LIMIT) return 0;
	
	c=0;
	for(int i=1; i<=MAX_PLAYER ; i++)
	{
		if( p[i].suzerain != user && p[i].status == STATUS_ALIVE ) c++;
	}
	
	if(c==1)
	{
		GameEndSetting(now);	//common.c
		return 1;
	}
	else return 0;
}


//"ϤȡۤȥྡԤˤʤޤ"ɽå
void check_alert_game_end(int user)
{
	if( p[user].ryoudo+4 >= GAME_CLEAR_COUNTRY && p[user].ryoudo < GAME_CLEAR_COUNTRY )
	{
		Log.write_alert_game_end(gdata.turn_count,user,GAME_CLEAR_COUNTRY-p[user].ryoudo); 
	}
}



//桼ȥ꡼ǽĴ٤
void CheckNoVacancy(void)
{	
	if(gdata.ninzuu >= gdata.plimit || gdata.turn_count > SANKA_TURN_LIMIT)
	{
		gdata.flag.NoVacancy = 1; return;
	}
	
	for(int cx=0;cx<MX;cx++) for(int cy=0;cy<MY;cy++) 
	{
		if( EexistHex(cx,cy) && map[cx][cy].boss == 0 )
		{
			gdata.flag.NoVacancy = 0;
			return;
		}
	}
	
	gdata.flag.NoVacancy = 1;
}
				

//delete_alliance
//Ʊ
void delete_alliance(int i)
{
	playerdata *tp;
	tp = &p[i];
	
	//Ʊ
	for(int j=1 ; j<=MAX_PLAYER ; j++)
	{	
		for(int d_type=0; d_type < ALLIANCE_TYPE ; d_type++)
		{
			if(d_type == SAME_IP) continue;
			
			if( tp->Alliance[d_type][j] )
			{
				tp->Alliance[d_type][j]  = 0;
				p[j].Alliance[d_type][i] = 0;
			}
		}
	}
}


//NPCŨΥǡ򥻥åȤ
void NPC_unit_touroku(unitdata *tu, int ud, int boss)
{
	tu->init();		//
	
	const U_ParameterSet *U_Para;
	U_Para = &U_Parameter[ ud ];
		
	strncpy( tu->name , U_Para->name, 16);
	tu->SerialNnumber = gdata.UnitSerialNnumber++;	//ꥢ
	//
	int Utype     = UnitData[ud].type;
	tu->type      = Utype;
	tu->level     = UnitData[ud].level;
	tu->gazou     = U_Parameter[ Utype ].gazou;
	tu->boss      = boss;
	
	if(U_Parameter[ Utype ].skill) {
		int sk = U_Parameter[ Utype ].skill;
		tu->skill( sk ,1);
		tu->SkillSelect = sk;
	}
	
	//ǡå
	tu->SetData();
	tu->status = STATUS_ALIVE;
	/*
	if(boss)
	{
		playerdata *tp;
		tp = &p[boss];
		int max_skill=0;
		//ѤߤεѤ򥹥ȿ
		for(int i=1 ; i<(sizeof TechData/sizeof TechData[0]) ; i++ )
		{
			if( check_skill_for_employ(tp,i) )	//ץ쥤䡼Ѥ򸦵Ѥߤɤ
			{
				int sk = TechData[i].skill;
				if( GetTypeFromSkill( sk, tu->type ) )	//Ѥ˥åȤΥפͭʤ
				{
					tu->skill( sk , 1);
					
					//Ʈѥ뤫
					if( SkillData[sk].SkillType != S_TYPE_None ) max_skill= sk;
				}
			}
		}
		if( tu->SkillSelect < max_skill) tu->SkillSelect = max_skill;
	}
	*/
	
	/*
	tarUnit->level = 1;
	tarUnit->gazou = U_Para->gazou;
	tarUnit->type  = npcNumber;
	
	int sk = U_Para->skill;
	if(sk) {
		tarUnit->skill( sk ,1 );
		tarUnit->SkillSelect = sk;
	}
		
	//ǡå
	tarUnit->SetData();
	tarUnit->status = STATUS_ALIVE;
	*/
}



//GetTypeFromSkill
//ѤͿ줿˥åȤΥפͭˤʤ뤫ɤ֤
int GetTypeFromSkill(int tech, int type)
{
	if(SKILL_REGIST_FIRE_1 <= tech && tech <= SKILL_REGIST_POISON_3) return 1;
	
	switch(type)
	{
		case TYPE_FIGHTER:
				if( (SKILL_F_HP_UP<=tech && tech<=SKILL_F_DEX_UP) 
				||	(SKILL_DOUBLE_IMPACT==tech) ) return 1;
				return 0;
				
		case TYPE_AXE:
				if( (SKILL_AXE_HP_UP<=tech && tech<=SKILL_AXE_DEX_UP)
				||  (SKILL_DOUBLE_SWING==tech || SKILL_TRIPLE_ATTACK==tech) ) return 1;
				return 0;
				
		case TYPE_PALADIN:
				if( (SKILL_PALADIN_HP_UP<=tech && tech<=SKILL_PALADIN_DEX_UP)
				 || (SKILL_HEELING<=tech && tech<=SKILL_PALADIN_COUNTER)
				 || (SKILL_PALADIN_SWING==tech) ) return 1;
				return 0;
				
		case TYPE_MAGE:
				if( (SKILL_M_HP_UP<=tech && tech<=SKILL_M_DEX_UP)
				||  (SKILL_FIREBALL<=tech && tech<= SKILL_ILLUSION_4) ) return 1;  
				return 0;
							
		case TYPE_HI_M:
				if( (SKILL_HI_M_HP_UP<=tech && tech<=SKILL_HI_M_DEX_UP)
				||  (SKILL_FIREBALL<=tech && tech<= SKILL_ILLUSION_4) ) return 1;  
				return 0;
				
		case TYPE_M_MASTER:
				if( (SKILL_M_MASTER_HP_UP<=tech && tech<=SKILL_M_MASTER_DEX_UP )
				||  (SKILL_FIREBALL<=tech && tech<= SKILL_ILLUSION_4) ) return 1;  
				return 0;
		
		case TYPE_MAGE_KNIGHT:
				if( SKILL_FIREBALL<=tech && tech<= SKILL_ILLUSION_4 ) return 1;  
				return 0;
			
		case TYPE_SNAKE_WOMAN:
				if( tech == SKILL_TEMPTATION ) return 1; else return 0;
		
		case TYPE_E_EEL_MAN:
				if( tech == SKILL_EEL_COUNTER ) return 1; else return 0;
		
		case TYPE_SKELETON_SYOGUN:
				if( tech == SKILL_SKELETON_POISON
				||  tech == SKILL_SKELETON_KANKOTSU) return 1;
				return 0;
		
		case TYPE_CRAB:
				if( tech == SKILL_KANI_POWERUP) return 1;
				return 0;
		
		default:
				return 0;
	}
}



//UnitSkillSet
//椷ƵѤˡͭ˥åȤΥȿǤؿ
void UnitSkillSet(int boss, int GetTech)
{
	for(int u=0 ; u <(sizeof unit/sizeof unit[0]) ; u++)
	{
		if(unit[u].boss == boss)
		{
			if( GetTypeFromSkill( TechData[GetTech].skill, unit[u].type) )
			{
				unit[u].skill( TechData[GetTech].skill , 1);
			}
		}
	}
}

int CheckNeedItem(int NeedItem , int cx, int cy)
{
	//пؤɬפʥƥब뤫Ĵ٤
	countrydata *tmap;
	tmap = &map[cx][cy];
	int NeedItem_SubType;
	
	NeedItem_SubType = Item[NeedItem].SubType;
	
	if( tmap->CheckJewel(NeedItem_SubType) ) return 1;
	
	for(int i=0 ; i<5 ; i++)
	{
		int u=tmap->UnitId[i];
		if(u==0) continue;
				
		if(unit[u].item && Item[unit[u].item].SubType==NeedItem_SubType) return 1;
	}
	return 0;
}


