//եǡɤ߹िΥ饹


//եϴطδؿ
//C/C++ˤCGIץߥ󥰤߷(վ͡)
//http://www-cms.phys.s.u-tokyo.ac.jp/~naoki/CIPINTRO/CCGI/
//˸Ƥ饤֥١ޤ




//strcmp2	strcmpɬפʵǽˤ®ǡʤΤĤ
#ifndef STRCMP2
#define STRCMP2
int strcmp2(register const char *p1, register const char *p2)
{
	while(*p1 || *p2)
	{
		if(*p1 != *p2) return 1;
		p1++;
		p2++;
	}
	return 0;
}
#endif


//strncmp2	strncmpɬפʵǽˤ®ǡʤΤĤ
#ifndef STRNCMP2
#define STRNCMP2
int strncmp2(register const char *p1, register const char *p2, int length)
{
	const char *p3;
	p3 = p1 + length;
	
	while( (*p1 || *p2) && p1<p3 )
	{
		if(*p1 != *p2) return 1;
		p1++;
		p2++;
	}
	return 0;
}
#endif



#ifndef _INPUT_FROM_FORM
#define _INPUT_FROM_FORM

struct FORM_TERM
{
	char* name;
	char* value;
};


class InputFromForm
{

public:

	//InputFromForm();
	//~InputFromForm();
	
	int 	getform_i(const char* keyname);
	double 	getform_d(const char* keyname);
	char* 	getform_c(const char* keyname);
		
private:
	
	int terms;		//ο
	FORM_TERM 	*term;
	char 		*TermBuff;
	
	void 	Receive(void);
	void	GetTerms(char* src);
	void 	Assign(char* src);
	void	Decode(char* src);
	char 	AtoH(char c);
	void 	Escape(char* src);
	
	int 	KanjiCode(char* text);
	void 	SJIStoEUC( u_char& knj1, u_char& knj2);
	void 	JIStoEUC( u_char& knj1, u_char& knj2 );
	
	void 	JIStoEUC( char* text );
	void 	SJIStoEUC( char* text );
	void 	ANYtoEUC( char* text );

public:
	InputFromForm()
	{
		Receive();	//TermBuff
		
		if(TermBuff == NULL) {
			terms = 0;
			return;
		}

		GetTerms(TermBuff);	//terms
		
		term = new FORM_TERM [terms];
		
		Assign(TermBuff);

	    // ѿͤ
   		for( int i=0; i<terms; i++ )
    	{
    		Decode(term[i].name );
    		Decode(term[i].value);
  		}
	}

	InputFromForm::~InputFromForm()
	{
		//if(terms)  				delete term;
		//if(TermBuff != NULL ) 	delete TermBuff;
	}
};


// ɼ
#define ASCII    0x00
#define EUC      0x01
#define SJIS     0x02
#define JIS      0x04
#define JAPANESE 0xff

// ƤǡưŪݤκ祵
#define MAX_MEMORY (8*1024)  // 8k bytes.


//FORMѿѰդƳǼ
void InputFromForm::Receive(void)
{
	TermBuff = NULL;
	
	char* method = getenv("REQUEST_METHOD");
  
	if(method && !strcmp2(method, "POST"))
	{
		char* env = getenv("CONTENT_LENGTH");
  		int length;
  
  		if( env != NULL && (length=atoi(env))>0 && length<MAX_MEMORY)
  		{
    		TermBuff = new char [length+1];
    		int n = fread( TermBuff, 1, length, stdin );
    		TermBuff[n] = '\0';
  		}
  	}
  	else if( method && !strcmp2( method, "GET" ) )
  	{
  		char* env = getenv("QUERY_STRING");
  		if(env) {
    		TermBuff = strdup(env);
  		}
 	}
}

//---- ѿθĿؿ
void InputFromForm::GetTerms(char* src)
{
	terms = 0;
  	while(*src)
  	{
    	if( *src == '=' ) terms++;
    	*src++;
  	}
}

//---- ѿ̾ͤΥɥ쥹ꤹؿ
void InputFromForm::Assign(char* src)
{
  	int i=0;
 	for( term[i].name = src; *src ; src++ )
 	{
    	if( *src == '=' )
    	{
      		*src = '\0';
      		term[i++].value = src+1;
    	}
    	else if( *src == '&' )
    	{
    		*src = '\0';
      		term[i].name = src+1;
    	}
  	}
}

//---- URL encode줿ǡȴɤѴ
void InputFromForm::Decode(char* src)
{
  	Escape(src);	// FORMͭ
	ANYtoEUC(src);	// ɤEUC
}

//---- ʸɽ16ʿѴؿ
inline char InputFromForm::AtoH(char c)
{
	if( '0' <= c && c <= '9' ) return c - '0';
	if( 'A' <= c && c <= 'F' ) return c - 'A' + 10;
	return 0;
}

//---- %ǻϤޤü쵭Ѵؿ
void InputFromForm::Escape(char* src)
{
	char* dst;
	for( dst=src; *src; src++ )
	{
  		if( *src == '%' )
  		{
    		*dst++ = (AtoH(*++src)<<4) + AtoH(*++src);
  		}
  		else if( *src == '+' )
  		{
    		*dst++ = ' ';
  		}
  		else
  		{
    		*dst++ = *src;
  		}
	}
	
	*dst++ = '\0';
}

//---- ɤȽؿ
int InputFromForm::KanjiCode(char* text)
{
	int flag = EUC;
	
	/*
	for( u_char* ptr=(u_char*)text; *ptr; ptr++ )
	{
		if( *ptr == 0x1b && *(ptr+1) == '$' ) return JIS;
    	if( *ptr <= 0x7F ) continue;	//ASCII
   	 	
   	 	if(*ptr==0x8E)
   	 	{
			if( (0x40 <= *(ptr+1) && *(ptr+1) < 0xA1) || 0xDF < *(ptr+1)) {
				return SJIS; 	// not EUCȾѥ
			}
			else flag = EUC;
		}
    	else if(*ptr==0x8F)
    	{
			if(0x40 <= *(ptr+1) && *(ptr+1) < 0xA1) {
				return SJIS; 	// not EUCĥ
			}
			else flag = EUC;
		}    
    	else if( 0x81 <= *ptr && *ptr <= 0x9F )
    	{
			return SJIS;
		}
		else if( 0xA1 <= *ptr && *ptr <= 0xDF )
    	{
			flag = EUC;	//:EUCsjisȾѥʤƱΰʤΤǤʤ
		}
		else if(*ptr == 0xFD || *ptr == 0xFE)
		{
			return EUC;
		}
		else if(0xE0 <= *ptr)
		{
			if(0x40 <= *(ptr+1) && *(ptr+1) < 0xA1 && *(ptr+1) != 0x8E && *(ptr+1) != 0x8F)
			{
				return SJIS;
			}
			else flag = EUC;
		}
    	   	
		//else if(*ptr < 0xFD && *(ptr+1) <= 0xA0 ) return SJIS;   //80A0 || E0FC
  	}
  	*/
  	
  	for( u_char* ptr=(u_char*)text; *ptr; ptr++ )
	{
		if( *ptr == 0x1b && *(ptr+1) == '$' ) return JIS;
    	if( *ptr <= 0x7F ) continue;	//ASCII
   	 	
   	 	if( 0x81 <= *ptr && *ptr <= 0x8D) return SJIS;	//SJIS ONLY AREA
		
		if(*ptr == 0xFD || *ptr == 0xFE) return EUC;	//EUC only area
		
   	 	
   	 	if(*ptr==0x8E)	//EUCȾѥʤ1Х 2ХܤA1-DF
   	 	{
			if( (0x40 <= *(ptr+1) && *(ptr+1) < 0xA1) || 0xDF < *(ptr+1)) {
				return SJIS; 	// not EUCȾѥ
			}
		}
		
		else if(*ptr==0x8F)	//EUCǤJIS 2,3ХܤA1-FE
    	{
			if( *(ptr+1) < 0xA1 || *(ptr+2) < 0xA1 ) {
				return SJIS; 	// not EUC
			}
			else
			if(0xA1 <= *(ptr+2) && *(ptr+2) < 0xE0) {
				return EUC;
			}
			else ptr++;
		}
		
		else if( *(ptr+1) <= 0xA0 ) return SJIS;

		ptr++;	//ѤǼʸޤǿʤ
    }
  	
  	return flag;
}

//---- SJISʸEUCʸѴؿ
void InputFromForm::SJIStoEUC( u_char& knj1, u_char& knj2 )
{
	knj1 <<= 1;
	if( knj2 < 0x9F )
	{
  		if( knj1 < 0x3F ) knj1 -= 0x61; else knj1 += 0x1F;
  		if( knj2 > 0x7E ) knj2 += 0x60; else knj2 += 0x61;
	}
	else
	{
  		if( knj1 < 0x3F ) knj1 -= 0x60; else knj1 += 0x20;
  		knj2 += 0x02;
	}
}

/*
//---- JISʸEUCʸѴ륵֥롼
void InputFromForm::JIStoEUC( u_char& knj1, u_char& knj2 )
{
	knj1 |= 0x80;
	knj2 |= 0x80;
}

//---- JISʸEUCʸѴؿ
void InputFromForm::JIStoEUC( char* text )
{
  int mode = ASCII;

  u_char *wr, *re;
  for( wr=re=(u_char*)text; *re; re++ ){
    if( (re[0]=='\x1b' && re[1]=='$' && re[2] == 'B' ) ||
	(re[0]=='\x1b' && re[1]=='$' && re[2] == '@' ) ){
      re+=2; 
      mode = JAPANESE;
      continue;
    }else if( (re[0]=='\x0f') ||
	      (re[0]=='\x1b' && re[1]=='(' && re[2] == 'B' ) ||
	      (re[0]=='\x1b' && re[1]=='(' && re[2] == 'J' ) ){
      re+=2; 
      mode = ASCII;
      continue;
    }else if( (re[0]=='\x0e') ||
	      (re[0]=='\x1b' && re[1]=='(' && re[2] == 'I' ) ){
      re+=2; 
      mode = ASCII; // hankaku IGNORE
      continue;
    }
    
    if( mode == ASCII ){
      *wr++ = *re;
      continue;
    }
    *wr++ = *re;
    if( !(*wr = *++re) ) break;
    JIStoEUC( *(wr-1), *wr );
    wr++;
  }
  *wr='\0';
}
*/

//---- SJISʸEUCʸѴؿ
void InputFromForm::SJIStoEUC( char* text )
{
	for( u_char* ptr=(u_char*)text; *ptr; ptr++ )
	{
    	if( *ptr < 0x80 ) continue;
    	if( !(*++ptr) ) break;
    	SJIStoEUC( *(ptr-1), *ptr );
  	}
}

//---- ǤդΥɤEUCѴؿ
void InputFromForm::ANYtoEUC( char* text )
{
 	 switch( KanjiCode( text ) ){
  		//case JIS  : JIStoEUC( text );  break;
  		case EUC  :                    break;
  		case SJIS : SJIStoEUC( text ); break;
  		case ASCII:                    break;
  	}
}

//getform_
int InputFromForm::getform_i(const char* keyname)
{
	int i=0;
	while(i<terms) { 
		if(strcmp2(keyname,term[i].name)==0) return atoi(term[i].value);
		i++;
	}
	return 0;
}

double InputFromForm::getform_d(const char* keyname)
{
	int i=0;
	while(i<terms) { 
		if(strcmp2(keyname,term[i].name)==0) return atof(term[i].value);
		i++;
	}
	return 0;
}

char* InputFromForm::getform_c(const char* keyname)
{
	int i=0;
	while(i<terms) {
			if(strcmp2(keyname,term[i].name)==0) return term[i].value;
			i++;
	}
	return NULL;
}

#endif
