//GameLogClass

#ifndef LOG_FILENAME
#define LOG_FILENAME	"logdata.cgi"
#endif

const char TR_CLASS1[] 	= "<tr class=\"log2\" valign=\"top\">" ;
const char TR[]			= "<tr valign=\"top\">" ; 
const char COLSPAN2[]   = "<td colspan=\"2\">" ;

class GameLogClass
{
private:
	FILE *fd;
	char tmp_buff[256];
	char hex[3];
		
public:
	void FileCreate(void);
	
	//read&write
	int GameLogClass::read(int ReadStartTurn, int login_user, int now_turn);
	void write_war(int turn,int cx,int cy,int tx,int ty,int from,int target,
					int HtmlId,int result);
	
	void read_war (int turn, int login_user);
	void write_settle(int turn,int cx,int cy,int tx,int ty,int from);
	
	void read_settle (int turn, int login_user);
	void write_diplomacy(int turn,int from,int target,int type,int period,int gold);
	
	void read_diplomacy(int turn, int login_user);
	int  diplomacy_check(int readturn,int from,int tmp_user,int type,int *gold,int *period);
	
	void write_diplomacy_Expiration(int turn,int from,int target,int type,int mode);
	void read_diplomacy_Expiration(int turn, int login_user);
	
	void write_diplomacy_reply(int turn, int from, int target ,int type,int agree);
	void read_diplomacy_reply(int turn, int login_user);
	void GameLogClass::PrintDiplomacyType(int type);
	
	void write_research_completion(int turn, int login_user, int type);
	void read_research_completion(int turn, int login_user);
	
	void write_FreeMessage(int turn, int login_user, int target, const char *mes);
	void read_FreeMessage(int turn, int login_user);
		
	//void write_food_fusoku(int turn, int login_user, int cx, int cy);
	//void read_food_fusoku(int turn, int login_user);
	int GameLogClass::print_food_fusoku(int turn, int login_user);

	void write_Jewel(int turn,int login_user,int target,int value,int mode);
	void read_Jewel(int turn, int login_user);
	
	void write_Kakumei(int turn, int login_user, int cx, int cy, int mode);
	void read_Kakumei(int turn, int login_user);
	
	void write_Epidemic(int turn,int login_user,int cx,int cy,int victim);
	void read_Epidemic(int turn, int login_user);
	
	void write_NewUser(int turn,int login_user);
	void read_NewUser(int turn, int login_user);
	
	void write_present(int turn, int king, int slave, int gold);
	void read_present(int turn, int login_user);
	
	void write_dependency(int turn, int from, int target, int period, int life) ;
	void read_dependency(int turn, int login_user);
	void PrintDiplomacySub(int turn,int login_user,int from,int target,
	                       int type,int period,int gold);
	
	void write_gameover(int turn, int from, int target);
	void read_gameover(int turn, int login_user);
	
	void GameLogClass::write_Disaste(int turn,int type,int c_number,int *TaX,int *TaY);
	void GameLogClass::read_Disaste(int turn, int login_user);
	
	void GameLogClass::write_alert_game_end(int turn, int user, int LastCountry) ;
	void GameLogClass::read_alert_game_end(int turn, int login_user);
	
	void GameLogClass::write_AddUser(int turn, const char *username);
	void GameLogClass::read_AddUser(int turn, int login_user);
	
	//ά
	void write_fire(int turn,int from,int target,int tx,int ty,int type,int value);
	void read_fire(int turn, int login_user);
		
	void write_steal(int turn,int from,int target,int tx,int ty,int type,int value);
	void read_steal(int turn, int login_user);
	
	void write_curse(int turn,int from,int target,int tx,int ty,int type,int value);
	void read_curse(int turn, int login_user);
	
private:
	void FileOpen(const char *mode);
	void FileClose(void);
	void xy_2_hex(int x,int y,char *str);
	void GameLogClass::tag_tr_select(int target, int login_user);
	void GameLogClass::tag_tr_select(int login_user,int target1, int target2 );
	void GameLogClass::put_turn(int turn);
};

//
//	ܴؿ
//


void GameLogClass::xy_2_hex(int x,int y,char *str)
{
	str[0] = y + 'A' ;
	str[1] = x + '1' ;
	str[2] = 0;
}	

void GameLogClass::FileCreate(void)
{
	if( ::room<1 || ::room > MAX_ROOM ) { printf("error! (log file-1)"); exit(0); }
	
	sprintf(tmp_buff, "room%04u/" LOG_FILENAME , ::room);	//ե͡
	
	fd = fopen(tmp_buff,"w");
	if(fd==NULL) { printf("error! (log file create)"); exit(0); }
	fclose(fd);
}		

void GameLogClass::FileOpen(const char *mode)
{
	if(::room<1 || ::room > MAX_ROOM) { printf("error! (log file-2)"); exit(0); }
	
	sprintf(tmp_buff, "room%04u/" LOG_FILENAME , ::room);	//ե͡
	
	fd = fopen(tmp_buff, mode);
	
	if(fd==NULL)
	{
		if(access(tmp_buff, F_OK)== -1)	//ե뤬¸ߤʤ 
		{
			FileCreate();
			fd = fopen(tmp_buff, mode);
		}
		else { printf("error! (log file-3)"); exit(0); }
	}
}	
	
void GameLogClass::FileClose(void)
{
	fclose(fd);
}

//HTML񤭽Фؿ

void GameLogClass::tag_tr_select(int target, int login_user)
{
	//ʬ˴طжĴɽ
	if(target == login_user)  {
		puts(TR_CLASS1);
	}
	else {
		puts(TR);
	}
}

void GameLogClass::tag_tr_select(int login_user,int target1, int target2 )
{
	//ʬ˴طжĴɽ
	if( (target1 && login_user==target1) || (target2 && login_user == target2) )  {
		puts(TR_CLASS1);
	}
	else {
		puts(TR);
	}
}

void GameLogClass::put_turn(int turn)
{
	//ǯɽ	
	printf("<td nowrap>%2dǯ%2d</td>", turn/12,(turn%12)+1);
}


// ========================  ɤ߽Фᥤ ========================


//ʲƮCGIλϥѥ뤷ʤ
#ifndef BATTLE_ONLY

//	============== 롼
//ɽᥤؿ
//ͤɽ̵ͭ
int GameLogClass::read(int ReadStartTurn, int login_user, int now_turn)
{
	int  turn;
	int  com;
	//bool fTable=0;
	bool flag = 0;
	
	FileOpen("r");
	
	puts("<table class=\"log1\" cellspacing=\"4\">");
	
	//loop
	while( fgets(tmp_buff,256,fd) != NULL )
	{
		if( sscanf(tmp_buff,"#%05d",&turn)==0 ) continue;
		if(turn<ReadStartTurn) continue;  //ƬФ 
		
		//command
		if( fgets(tmp_buff,256,fd)==NULL) break; 
		if( sscanf(tmp_buff,"$%02d",&com)==0 ) break;
		//data
		if( fgets(tmp_buff,256,fd)==NULL) break; 
		
		//if(login_user==0 && com) continue;	//󤷤ƤʤΤ
		
		//if(0==fTable) {printf("<table class=\"log1\">");fTable=1;}	
		flag =1;
		switch(com)
		{
			case 0:	read_war(turn,login_user);
					break;
			case 1:	read_settle(turn,login_user);
					break;
			case 2: read_diplomacy(turn,login_user);
					break;
			case 3:	read_diplomacy_Expiration(turn,login_user);
					break;
			case 4:	read_diplomacy_reply(turn,login_user);
					break;
			case 5:	read_research_completion(turn,login_user);		
					break;
			//case 6:	read_FreeMessage(turn,login_user);	
			//		break;
			case 7:	read_Jewel(turn,login_user);	
					break;
			case 8:	read_Kakumei(turn,login_user);	
					break;
			case 9:	read_Epidemic(turn,login_user);	
					break;
			case 10:
					read_NewUser(turn,login_user);	//С
					break;
			case 11:
					read_present(turn,login_user);	
					break;
			case 12:
					read_dependency(turn,login_user);	
					break;
			case 13:
					read_gameover(turn,login_user);	
					break;
			
			case 14:
					read_Disaste(turn,login_user);
					break;
			
			case 15:
					read_alert_game_end(turn, login_user);
					break;
			
			case 16:
					read_AddUser(turn,login_user);	//NEWС
					break;
			
			case 17:
					read_fire(turn,login_user);
					break;
			
			case 18:
					read_steal(turn,login_user);
					break;
			case 19:
					read_curse(turn,login_user);
					break;
			
		}
	}
	FileClose();
	
	if(login_user && print_food_fusoku(now_turn,login_user) ) flag= 1;//
	if(login_user && Auction.PrintLog(login_user))            flag= 1;//

	if(flag==0) puts("<tr><td>äˤʤ</td></tr>");
	puts("</table>");

	return flag;
}

#endif

//
//		
//

const char WAR_FORMAT[] = "%d %d %d %d %d %d %d %d\n";

//write_war
void GameLogClass::write_war(int turn,int cx,int cy,int tx,int ty,int from,int target,int HtmlId,int result)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$00\n");
	//ޤ귿
	fprintf(fd,WAR_FORMAT,cx,cy,tx,ty,from,target,HtmlId,result);
	FileClose();	
}

void GameLogClass::read_war(int turn, int login_user)
{
	int cx,cy,tx,ty,from,target,HtmlId,result; 
	
	sscanf(tmp_buff,WAR_FORMAT, &cx,&cy,&tx,&ty,&from,&target,&HtmlId,&result);
	
	tag_tr_select(login_user,target,from );	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	xy_2_hex(cx,cy,hex);
	printf("<td>%s(%s)", p[from].name ,hex);
	
	xy_2_hex(tx,ty,hex);
	printf("%s(%s)˿" , p[target].name ,hex);
	
	//RESULT_VICTORY, 	RESULT_DEFEAT, 	RESULT_DRAW, 	RESULT_TIMEOVER,
	//RESULT_NO_RESULT,	RESULT_BLOODLESS_VICTORY,	RESULT_BLOODLESS_DEFEAT
	bool showBattleFlag = 0;
	switch(result)
	{
		case RESULT_VICTORY:
			printf("");
			showBattleFlag=1;
			break;
		
		case RESULT_DEFEAT:
			printf("餱");
			showBattleFlag=1;
			break;
		
		case RESULT_DRAW:		
		case RESULT_TIMEOVER:
		case RESULT_NO_RESULT:
			printf("ʬ");
			showBattleFlag=1;
			break;
			
		case RESULT_BLOODLESS_VICTORY:
			printf("̵쾡");
			break;
	}
	
	puts("</td><td>");
	
	//Ʈ򸫤ץܥ
	if(showBattleFlag)
	{
		printf(	"<input type=\"button\" value=\"Ʈ򸫤\" "
			 	"onClick=\"w_open('%04d');\" class=\"button2\">"
				, HtmlId );
	}
	else  puts("&nbsp;");
	
	puts("</td></tr>");
}







//

const char SETTLE_FORMAT[] = "%d %d %d %d %d\n";

void GameLogClass::write_settle(int turn,int cx,int cy,int tx,int ty,int from)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$01\n");
	//ޤ귿
	fprintf(fd,SETTLE_FORMAT,cx,cy,tx,ty,from);
	FileClose();
}

void GameLogClass::read_settle(int turn, int login_user)
{
	int cx,cy,tx,ty,from; 
		
	sscanf(tmp_buff,SETTLE_FORMAT, &cx,&cy, &tx,&ty,&from);
	
	puts(TR);
	put_turn(turn);						//ǯɽ
	
	xy_2_hex(cx,cy,hex);
	puts( COLSPAN2 );
	printf("%s(%s)", p[from].name ,hex);
	xy_2_hex(tx,ty,hex);
	printf("(%s)ڤˤޤ" ,hex);
	printf("</td></tr>");
}




//ʲƮCGIλϥѥ뤷ʤ
#ifndef BATTLE_ONLY





//

const char DIPLOMACY_FORMAT[] = "%d %d %d %d %d\n";

void GameLogClass::PrintDiplomacyType(int type)
{
	switch(type)
	{
		case DOUMEI_WAHEI:			//0
			printf("ʿƱ");
			return;
		
		case DOUMEI_TECH:			//1
			printf("");
			return;
			
		default:
			break;
	}
}

void GameLogClass::PrintDiplomacySub(int turn,   int login_user,int from,
                                     int target, int type,      int period, int gold)
{
	PrintDiplomacyType(type);
	
	printf("(%d,%d)ƤƤޤ",period,gold);
	puts("</td>");
	
	if(login_user==target)
	{
		//ʤ
		if( p[from].Alliance[type][target] < 0 ) //gdata.turn_count - turn <4)
		{
			//ܥɽ
			printf(
				"<td>"
				"<input type=\"button\" value=\"  \" "
				"onClick=\"diplomacy('turn=%d&from=%d&type=%d&agree=1');\" "
				"class=\"button2\">"
				""
				"<input type=\"button\" value=\" Ǥ \" "
				"onClick=\"diplomacy('turn=%d&from=%d&type=%d&agree=0');\" "
				"class=\"button2\">"
				"</td></tr>\n"
				, turn,from,type , turn,from,type);
		}
		else
		{
			if(p[from].Alliance[type][target]==0) puts("<td>ʸĴֽλ</td></tr>");
			else puts("<td>&nbsp;</td></tr>");
		}	
	}
	else
	{
		puts("<td>&nbsp;</td></tr>");
	}
}


void GameLogClass::write_diplomacy(int turn,int from,int target,int type,int period,int gold)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$02\n");
	//ޤ귿
	fprintf(fd,DIPLOMACY_FORMAT, from,target,type,period,gold);
	FileClose();
}

void GameLogClass::read_diplomacy(int turn, int login_user)
{
	int from,target,type,period,gold;
	
	sscanf(tmp_buff,DIPLOMACY_FORMAT, &from,&target,&type,&period,&gold);
	
	tag_tr_select(login_user,target,from);	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	printf("<td>%s%s",p[from].name, p[target].name);	
	
	switch(type)
	{
		case 0:
		case 1:
			PrintDiplomacySub(turn, login_user, from, target, type, period, gold);
			break;
			
		case 10:
			printf("%d£褷ޤ</td></tr>",gold);
			break;
		
		case 11:
			printf("%d£褷ޤ</td></tr>",gold);
			break;
		
		case 12:
			xy_2_hex(period,gold,hex);	// period=cx , gold=cy
			printf("(%s)£褷ޤ</td></tr>",hex);
			break;
	}
	
}

//Ʊڤ

const char DIPLOMACY_EXPIRATION_FORMAT[] = "%d %d %d %d\n";

void GameLogClass::write_diplomacy_Expiration(int turn,int from,int target,int type,int mode)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$03\n");
	//ޤ귿
	fprintf(fd,DIPLOMACY_EXPIRATION_FORMAT, from,target,type,mode);
	FileClose();
}
void GameLogClass::read_diplomacy_Expiration(int turn, int login_user)
{
	int  from,target,type,mode;
	
	sscanf(tmp_buff,DIPLOMACY_EXPIRATION_FORMAT, &from,&target,&type,&mode);
	
	//ʬ˴طжĴɽ
	bool flag=0;
	
	if(login_user==from || login_user==target) {
		puts(TR_CLASS1);
		flag=1;
	}
	else {
		puts(TR);
	}

	put_turn(turn);						//ǯɽ
		
	puts( COLSPAN2 );
	
	if(flag)
	{
		int i= (login_user == from) ? target : from;
		printf("%sȤ",p[i].name);
	}
	else
	{
		printf("%s%s",p[from].name, p[target].name);	
	}
	
	PrintDiplomacyType(type);

	switch(mode)
	{
		case 0:	puts( "ڤˤʤޤ</td></tr>" );
				break;
		case 1:	puts( "϶­ΤὪλޤ<td></tr>" );
				break;
	}
}

//Ʊ׵ؤֻ

const char DIPLOMACY_REPLY_FORMAT[] = "%d %d %d %d\n";

void GameLogClass::write_diplomacy_reply(int turn,int from,int target,int type,int agree)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$04\n");
	//ޤ귿
	fprintf(fd,DIPLOMACY_REPLY_FORMAT, from, target, type, agree);
	FileClose();
}
void GameLogClass::read_diplomacy_reply(int turn, int login_user)
{
	int from,target,type,agree;
	
	sscanf(tmp_buff,DIPLOMACY_REPLY_FORMAT, &from,&target,&type,&agree);
	
	tag_tr_select(login_user,target,from);	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s%sƤƤ"
			,p[from].name, p[target].name);	

	PrintDiplomacyType(type);
	
	switch(agree)
	{
		case 1:
			printf("Ͼޤ");
			break;
		case 0:
			printf("Ǥޤ");
			break;
		case 2:
			printf("ϻ­Τ̵ˤʤޤ");
			break;
	}
	puts( "</td></tr>" );
	//printf("<td>&nbsp;</td></tr>\n");
}

//Ʊ椫å
int GameLogClass::diplomacy_check(int readturn,int from,int tmp_user,int type,int *gold,int *period)
{
	int  turn;
	int  com=0;
	int  r_user,r_target,r_type,r_period,r_gold;
	
	FileOpen("r");
	while( fgets(tmp_buff,256,fd)!=NULL )
	{
		if( sscanf(tmp_buff,"#%05d",&turn)==0 ) continue;
		if(turn<readturn) continue;  	//ƬФ 
		if(turn>readturn) break;  		//Ͽ̵ 
		
		//command (diplomacy=02)
		if( fgets(tmp_buff,256,fd)==NULL) break;
		sscanf(tmp_buff,"$%02d",&com);
		if( com != 2 ) continue;
		
		//data
		if( fgets(tmp_buff,256,fd)==NULL) break;
		sscanf(tmp_buff,DIPLOMACY_FORMAT,&r_user,&r_target,&r_type,&r_period,&r_gold);
		
		if(from==r_user && tmp_user==r_target && type==r_type 
		   && p[r_user].Alliance[r_type][r_target] < 0 )
		{		
			*gold   = r_gold;
			*period = r_period;
			return 1;
		}
	}
	FileClose();
	return 0;
}



//洰λ

const char RESEARCH_COMPLETION_FORMAT[] = "%d %d\n";

void GameLogClass::write_research_completion(int turn, int login_user, int type)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$05\n");
	//ޤ귿
	fprintf(fd,RESEARCH_COMPLETION_FORMAT, login_user ,type);
	FileClose();
}
void GameLogClass::read_research_completion(int turn, int login_user)
{
	int researcher,type;
	sscanf(tmp_buff,RESEARCH_COMPLETION_FORMAT, &researcher , &type);
	
	tag_tr_select(researcher,login_user);	//ʬ˴طжĴɽ
	put_turn(turn);						//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s%sθλޤ</td></tr>\n"
			,p[researcher].name, TechData[type].name);	
}

//­ʤ衼

int GameLogClass::print_food_fusoku(int turn, int login_user)
{
	for(register int cy=0;cy<MY;cy++) for(register int cx=0;cx<MX;cx++)
	{
		if( login_user == map[cx][cy].boss && 100 != map[cx][cy].jikyuuritsu )
		{
			puts(TR_CLASS1);
			put_turn(turn);					//ǯɽ
			puts( COLSPAN2 );
			puts("­Ƥޤ</td></tr>\n");	
			return 1;
		}
	}
	return 0;
}

#endif

//ե꡼å
/*
const char FREE_MESSAGE_FORMAT[] = "%02d %02d %s\n";

void GameLogClass::write_FreeMessage(int turn, int login_user, int target, const char *mes)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$06\n");
	//ޤ귿
	fprintf(fd,FREE_MESSAGE_FORMAT, login_user, target, mes);
	FileClose();
}
void GameLogClass::read_FreeMessage(int turn, int login_user)
{
	int target1, target2;
	//char buff[256];
	
	sscanf(tmp_buff,FREE_MESSAGE_FORMAT, &target1, &target2 , common_buff);
	
	tag_tr_select(login_user,target1,target2 );	//ʬ˴طжĴɽ
	put_turn(turn);								//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s</td></tr>\n",common_buff);	
}
*/



//ʲƮCGIλϥѥ뤷ʤ
#ifndef BATTLE_ONLY




//ƥФϤǶ⤫åä
const char JEWEL_MESSAGE_FORMAT[] = "%d %d %d %d\n";

void GameLogClass::write_Jewel(int turn,int login_user,int target,int value,int mode)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$07\n");
	//ޤ귿
	fprintf(fd,JEWEL_MESSAGE_FORMAT,login_user,target,mode , value);
	FileClose();
}
void GameLogClass::read_Jewel(int turn, int login_user)
{
	int target1, target2, value, mode;
		
	sscanf(tmp_buff,JEWEL_MESSAGE_FORMAT,&target1,&target2,&mode, &value);
		
	
	tag_tr_select(login_user,target1,target2 );	//ʬ˴طжĴɽ
	put_turn(turn);								//ǯɽ
	
	puts( COLSPAN2 );
	printf("%sϥƥϤ",p[target1].name );
	
	switch(mode)
	{
		case 1:
			printf("%s%dåޤ" , p[target2].name , value);
			break;
		
		case 2:
			printf("%sǼ%d餷ޤ" , p[target2].name , value);
			break;
		
		case 3:
			printf("%sμϤ%d餷ޤ" , p[target2].name , value);
			break;
			
	}	
	puts("</td></tr>");	
}



//̿˽ư
const char KAKUMEI_MESSAGE_FORMAT[] = "%d %d %d %d\n";

void GameLogClass::write_Kakumei(int turn, int login_user, int cx, int cy, int mode)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$08\n");
	//ޤ귿
	fprintf(fd,KAKUMEI_MESSAGE_FORMAT, login_user, cx, cy, mode);
	FileClose();
}
void GameLogClass::read_Kakumei(int turn, int login_user)
{
	int target, cx, cy , mode;
		
	sscanf(tmp_buff,KAKUMEI_MESSAGE_FORMAT, &target, &cx, &cy, &mode);
	
	xy_2_hex(cx,cy,hex);
	
	tag_tr_select(target,login_user);	//ʬ˴طжĴɽ
	put_turn(turn);						//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s(%s)" , p[target].name , hex );
	
	if(mode==0) printf("˽ưȯ̵ܾ֤ˤʤޤ");
	else
	{
		printf("˽ưȯ");
		
		     if(mode & 0x6) printf("ʪΤﳲ");
		else if(mode & 0x2) printf("ʪﳲ");		
		else if(mode & 0x4) printf("Τﳲ");	
		
		printf("ޤ");
	}
	
	puts("</td></tr>");	
}

//¥
const char EPIDEMIC_MESSAGE_FORMAT[] = "%d %d %d %d\n";

void GameLogClass::write_Epidemic(int turn,int login_user,int cx,int cy,int victim)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$09\n");
	//ޤ귿
	fprintf(fd,EPIDEMIC_MESSAGE_FORMAT, login_user, cx, cy, victim);
	FileClose();
}
void GameLogClass::read_Epidemic(int turn, int login_user)
{
	int target, cx, cy , victim;
		
	sscanf(tmp_buff,EPIDEMIC_MESSAGE_FORMAT, &target, &cx, &cy, &victim);
	
	xy_2_hex(cx,cy,hex);
	
	tag_tr_select(target,login_user);	//ʬ˴طжĴɽ
	put_turn(turn);						//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s(%s)Ǳ¤ȯ̱%dͤ˴ޤ</td></tr>"
			, p[target].name , hex ,victim);
	
}




//˥塼桼
const char NEW_USER_FORMAT[] = "%d\n";

void GameLogClass::write_NewUser(int turn, int login_user)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$10\n");
	//ޤ귿
	fprintf(fd,NEW_USER_FORMAT, login_user);
	FileClose();
}
void GameLogClass::read_NewUser(int turn, int login_user)
{
	int target;
		
	sscanf(tmp_buff,NEW_USER_FORMAT, &target);
		
	tag_tr_select(target,login_user);	//ʬ˴طжĴɽ
	put_turn(turn);						//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s˻äޤ</td></tr>", p[target].name);
}



//˥塼桼(new)
const char ADD_USER_FORMAT[] = "%s\n";

void GameLogClass::write_AddUser(int turn, const char *username)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$16\n");
	//ޤ귿
	fprintf(fd, ADD_USER_FORMAT, username);
	FileClose();
}
void GameLogClass::read_AddUser(int turn, int login_user)
{
	int target;
		
	sscanf(tmp_buff,ADD_USER_FORMAT,common_buff);
		
	//tag_tr_select(target,login_user);	//ʬ˴طжĴɽ
	puts(TR);
	put_turn(turn);						//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s˻äޤ</td></tr>",common_buff);
}






//˸
const char PRESENT_FORMAT[] = "%d %d %d\n";

void GameLogClass::write_present(int turn, int king, int slave, int gold) 
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$11\n");
	//ޤ귿
	fprintf(fd,PRESENT_FORMAT, king, slave, gold );
	FileClose();	
}

void GameLogClass::read_present(int turn, int login_user)
{
	int king, slave, gold ;
	
	sscanf(tmp_buff,PRESENT_FORMAT, &king, &slave, &gold );
	
	tag_tr_select(login_user,king, slave);	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	puts( COLSPAN2 );
	printf("%sϽǤ%s˶%d򸥾夷ޤ</td></tr>"
			,p[slave].name ,p[king].name ,gold);
}


//ҳdisaste

const char DISASTE_FORMAT[] = "%d %s\n";

void GameLogClass::write_Disaste(int turn,int type,int c_number,int *TaX,int *TaY)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$14\n");
	//ޤ귿
	
	// " A1,B8,C5 " ʸ
	int p=0;
	common_buff[0] = 0;
	for(int i=0; i<c_number; i++)
	{
		//if(i) common_buff[p++] = ',' ;
		common_buff[p++] = TaY[i] + 'A' ;
		common_buff[p++] = TaX[i] + '1' ;
	}
	common_buff[p] = 0;
	
	fprintf(fd,DISASTE_FORMAT, type, common_buff);
	FileClose();
}
void GameLogClass::read_Disaste(int turn, int login_user)
{
	int target, type , p;
	int cx,cy;
	bool bold_flag;
			
	sscanf(tmp_buff,DISASTE_FORMAT, &type, common_buff);
		
	puts(TR);
	put_turn(turn);		//ǯɽ
	puts( COLSPAN2 );
	
	//printf(" " );
	
	p=0;
	bold_flag=0;
	while( common_buff[p] )
	{
		cy = common_buff[p  ] - 'A' ;
		cx = common_buff[p+1] - '1' ;
				
		if(p) putchar( ',' );
		
		if( map[cx][cy].boss == login_user ) {
			printf("<font color=\"#000000\"><b>");
			bold_flag = 1;
		}
		putchar(common_buff[p++] );
		putchar(common_buff[p++] );
		
		if(bold_flag) { printf("</b></font>"); bold_flag = 0; }
	}
	
	switch(type)
	{
		case HIDERI:
			printf("Ȥ꤬³ʪﳲФƤޤ");
			break;
		
		case INAGO:
			printf("ǥʥ緲ʪ򿩤ԤƤޤ");
			break;
		
		case JISHIN:
			printf("Ͽ̤ȯʪﳲޤ");
			break;
			
		case DAI_JISHIN:
		case GOD_JISHIN:
			printf("Ͽ̤ȯʪ礭ﳲޤ");
			break;
		
		case KOUZUI:
			printf("ǲʪﳲФƤޤ");
			break;
		
		case HOUSAKU:
			printf("ɤŷ³Τ˭ˤʤꤽǤ");
			break;
			
	}
	
	puts("</td></tr>");			
}


//
// <--ά
//

// 17
const char FIRE_FORMAT[] = "%d %d %d %d %d %d\n";

void GameLogClass::write_fire(int turn,int from,int target,int tx,int ty,int type,int value) 
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$17\n");
	//ޤ귿
	fprintf(fd,FIRE_FORMAT,from,target,tx,ty,type,value);
	FileClose();	
}
void GameLogClass::read_fire(int turn, int login_user)
{
	int from,target,type,value,tx,ty; 
		
	sscanf(tmp_buff,FIRE_FORMAT,&from,&target,&tx,&ty,&type,&value);
	
	tag_tr_select(login_user,target,from );	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	xy_2_hex(tx,ty,hex);
	puts( COLSPAN2 );
	printf("%s%s(%s)˿", p[from].name ,p[target].name, hex);
	
	if(type==0) printf("ʪ%dФޤ",value);
	else        printf("%dФޤ",value);
	
	printf("</td></tr>");
}

// 18
const char STEAL_FORMAT[] = "%d %d %d %d %d %d\n";
void GameLogClass::write_steal(int turn,int from,int target,int tx,int ty,int type,int value)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$18\n");
	//ޤ귿
	fprintf(fd,STEAL_FORMAT,from,target,tx,ty,type,value);
	FileClose();	
}
void GameLogClass::read_steal(int turn, int login_user)
{
	int from,target,type,value,tx,ty; 
		
	sscanf(tmp_buff,STEAL_FORMAT,&from,&target,&tx,&ty,&type,&value);
	
	tag_tr_select(login_user,target,from );	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	xy_2_hex(tx,ty,hex);
	puts( COLSPAN2 );
	printf("%s%s(%s)˿%dߤޤ"
			,p[from].name ,p[target].name, hex,value);
	
	printf("</td></tr>");
}

// 19
const char CURSE_FORMAT[] = "%d %d %d %d %d %d\n";
void GameLogClass::write_curse(int turn,int from,int target,int tx,int ty,int type,int value) 
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$19\n");
	//ޤ귿
	fprintf(fd,CURSE_FORMAT,from,target,tx,ty,type,value);
	FileClose();	
}
void GameLogClass::read_curse(int turn, int login_user)
{
	int from,target,type,tx,ty,value; 
		
	sscanf(tmp_buff,FIRE_FORMAT,&from,&target,&tx,&ty,&type,&value);
	
	tag_tr_select(login_user,target,from);	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	xy_2_hex(tx,ty,hex);
	puts( COLSPAN2 );
	printf("%s%s(%s)", p[from].name ,p[target].name, hex);
	
	switch(type)
	{
		case STRATAGEM_CURSE_BAD_HARVEST_1:
				printf("˶μݤ̤%d0%%㲼ޤ",value);
				break;
				
		case STRATAGEM_CURSE_BAD_HARVEST_2:
				printf("綧μݤ̤%d0%%㲼ޤ",value);
				break;
				
		case STRATAGEM_CURSE_BAD_HARVEST_3:
				printf("Ķμݤ̤%d0%%㲼ޤ",value);
				break;
		
		case STRATAGEM_CURSE_EARTHQUAKE_1:
				printf("Ͽ̤μݤʪ%d˲ޤ",value);
				break;
		
		case STRATAGEM_CURSE_EARTHQUAKE_2:
				printf("Ͽ̤μݤʪ%d˲ޤ",value);
				break;
						
		case STRATAGEM_CURSE_EPIDEMIC_1:
		case STRATAGEM_CURSE_EPIDEMIC_2:
				printf("˱¤μݤƽ̱%dͤ»वޤ",value);
				break;
		
		case STRATAGEM_CURSE_WEAK_1:
				printf("μβμLv1ݤޤδ֡Τ̿Ϥ㲼ޤ");
				break;
		case STRATAGEM_CURSE_WEAK_2:
				printf("μβμLv2ݤޤδ֡Τ̿Ϥ㲼ޤ");
				break;
		/*
		case STRATAGEM_CURSE_NO_EMPLOY:
		case STRATAGEM_CURSE_YOBI_1:
		case STRATAGEM_CURSE_YOBI_2:
		case STRATAGEM_CURSE_YOBI_3:
		case STRATAGEM_CURSE_YOBI_4:
		*/
		
		case STRATAGEM_RUMOR:			//ή
				printf("ǰήٻΨ㲼ޤ");
				break;
		
		case STRATAGEM_INSTIGATION:		//ư
				printf("ǽ̱ưޤ");
				break;
		
		case STRATAGEM_HEADHUNT:		//ȴ
				printf("%dͤΤȴޤ",value);
				break;
		
		case STRATAGEM_REBELLION:		//ȿ
				printf("ȿ򵯤Τˤޤ");
				break;
		
		case STRATAGEM_DISTURBANCE_RESEARCH_1:
		case STRATAGEM_DISTURBANCE_RESEARCH_2:
				printf("Ǹ˸򤷤Ƹ֤%d餻ޤ",value);
				break;
		
		case STRATAGEM_PRAY_GOOD_HEARVEST_1:
		case STRATAGEM_PRAY_GOOD_HEARVEST_2:
				printf("˭ԤޤμϤ%d0%%徺ޤ",value);
				break;
				
		case STRATAGEM_PRAY_GOOD_PROSPERITY_1:
		case STRATAGEM_PRAY_GOOD_PROSPERITY_2:
				printf("˷ʵ徺ԤޤǼ%d0%%徺ޤ",value);
				break;
		
		case STRATAGEM_PRAY_F_STRENGTH_1:
				printf("ζLv1Ԥޤδ֡Τ̿Ϥ徺ޤ");
				break;
		case STRATAGEM_PRAY_F_STRENGTH_2:
				printf("ζLv2Ԥޤδ֡Τ̿Ϥ徺ޤ");
				break;
		/*		
		case STRATAGEM_PRAY_REJECT_CURSE:
		case STRATAGEM_PRAY_REPAY_CURSE:
		*/
	}
	
	printf("</td></tr>");
}


#endif

//°񤵤줿Υ
const char DEPENDENCY_FORMAT[] = "%d %d %d %d\n";

void GameLogClass::write_dependency(int turn, int from, int target, int period, int life) 
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$12\n");
	//ޤ귿
	fprintf(fd,DEPENDENCY_FORMAT, from, target, period, life );
	FileClose();	
}
void GameLogClass::read_dependency(int turn, int login_user)
{
	int from, target, period , life;
	
	sscanf(tmp_buff,DEPENDENCY_FORMAT, &from, &target, &period, &life);
	
	tag_tr_select(login_user,from, target);	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	puts( COLSPAN2 );
	printf("%sϤ%dδ֡%s°ˤʤޤ<br>"
			"%d°ˤȥ४СǤ</td></tr>"
			,p[target].name, period, p[from].name, life+1 );
}






//gameover
const char GAME_OVER_FORMAT[] = "%d %d\n";

void GameLogClass::write_gameover(int turn, int from, int target) 
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$13\n");
	//ޤ귿
	fprintf(fd,GAME_OVER_FORMAT, from, target);
	FileClose();	
}
void GameLogClass::read_gameover(int turn, int login_user)
{
	int from, target ;
	
	sscanf(tmp_buff,GAME_OVER_FORMAT, &from, &target );
	
	tag_tr_select(login_user,from, target);	//ʬ˴طжĴɽ
	put_turn(turn);							//ǯɽ
	
	puts( COLSPAN2 );
	printf("%s%sˤäǤܤޤ</td></tr>"
			,p[target].name, p[from].name );
}


//alert_game_end
const char ALERT_GAME_END_FORMAT[] = "%d %d\n";

void GameLogClass::write_alert_game_end(int turn, int user, int LastCountry)
{
	FileOpen("a");
	fprintf(fd,"#%05d\n",turn);
	fprintf(fd,"$15\n");
	//ޤ귿
	fprintf(fd,ALERT_GAME_END_FORMAT, user, LastCountry);
	FileClose();	
}
void GameLogClass::read_alert_game_end(int turn, int login_user)
{
	int user, LastCountry;
	sscanf(tmp_buff,ALERT_GAME_END_FORMAT, &user, &LastCountry);
	
	tag_tr_select(user,user);	//Ĵɽ
	put_turn(turn);				//ǯɽ
	
	puts( COLSPAN2 );
	printf(	"<font color=\"#FF0000\">"
			"%sϡ%dۤȥྡԤˤʤޤ"
			"</font></td></tr>"
			,p[user].name, LastCountry);
}
